import { system, world } from "@minecraft/server";
import { formBuilder } from "./engine/formBuilder";


system.afterEvents.scriptEventReceive.subscribe(ev => {
    if (ev.id === "tdp:open_form") {
        formBuilder("temp_menu", ev.sourceEntity);
    } else if (ev.id === "tdp:form") {
        formBuilder("modal_menu", ev.sourceEntity);
    }
});

world.beforeEvents.itemUse.subscribe(ev => {
    const item = ev.itemStack;
    if (!item) return;
    const player = ev.source;
    if (!player) return;
    if (item.typeId == "minecraft:stick") {
        formBuilder("modal_menu", player);
    }
});